function [] = pssetactivechannels(n)
%PSSETACTIVECHANNELS    Activate the current channels in the current document. 
%   PSSETACTIVECHANNELS(N) N is a cell array with the name of the channels
%   to activate.
%
%   Example:
%   pssetactivechannels({'Red', 'Green'});
%
%   See also PSGETPIXELS, PSSETPIXELS, PSCONFIG, PSCHANNELNAMES,
%   PSNUMCHANNELS

%   Thomas Ruark, 2/23/2006
%   Copyright 2006 Adobe Systems Incorporated

% Convert the cell array to a JavaScript array
b = '[';
for x = 1 : length(n)
    b = [b '"' n{x} '",'];
end
b = [b ']'];

% build up JavaScript to send to Photoshop
pstext = ['var errorDetails = "";' ...
    'var newnames = ' b ';' ...
    'var newchannels = [];' ...
    'var result = "";' ...
    'try {' ...
    '    for (var i = 0; i < newnames.length; i++) {' ...
    '        newchannels.push(app.activeDocument.channels[ newnames[i] ]);' ...
    '    }' ...
    '    app.activeDocument.activeChannels = newchannels;' ...
    '    result = "OK";' ...
    '}' ...
    'catch(e) {' ...
    '    errorDetails = e.toString();' ...
    '    result = "FAIL";' ...
    '}' ...
    'result = result + errorDetails;' ...
    'result;'];

psresult = psjavascriptu(pstext);

lo = strfind(psresult, 'OK');

if isempty(lo)
    error(psresult(length('FAIL') + 1:end));
end
